const jwt = require('jsonwebtoken');

// Generate JWT token
const generateToken = (userId) => {
  return jwt.sign({ userId }, process.env.JWT_SECRET, { expiresIn: '7d' });
};

// Generate mobile JWT token with 6 months expiration
const generateMobileToken = (userId) => {
  return jwt.sign({ userId }, process.env.JWT_SECRET, { expiresIn: '180d' });
};

// Generate unique ID (4-6 characters)
const generateUniqueId = (prefix = '') => {
  const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
  let result = '';
  for (let i = 0; i < 6; i++) {
    result += chars.charAt(Math.floor(Math.random() * chars.length));
  }
  return `${prefix}${result}`;
};

// Validate email
const isValidEmail = (email) => {
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  return emailRegex.test(email);
};

// Validate mobile number (Bangladesh format)
const isValidMobile = (mobile) => {
  const mobileRegex = /^(\+88)?01[3-9]\d{8}$/;
  return mobileRegex.test(mobile);
};

// Normalize mobile number
const normalizeMobile = (mobile) => {
  // Remove +88 and spaces/dashes
  return mobile.replace(/[\s\-\+]/g, '').replace(/^88/, '');
};

// Date helpers
const isDateInRange = (date, startDate, endDate) => {
  const checkDate = new Date(date);
  const start = new Date(startDate);
  const end = new Date(endDate);
  return checkDate >= start && checkDate <= end;
};

module.exports = {
  generateToken,
  generateMobileToken,
  generateUniqueId,
  isValidEmail,
  isValidMobile,
  normalizeMobile,
  isDateInRange
};