const express = require('express');
const router = express.Router();
const { auth, adminOnly } = require('../middleware/auth');
const { authRateLimit } = require('../middleware/security');
const {
  registerUser,
  loginUser,
  getProfile,
  getAllUsers,
  updateUser,
  deleteUser
} = require('../controllers/userController');

// Public routes
router.post('/login', authRateLimit, loginUser);

// Protected routes
router.get('/profile', auth, getProfile);

// Admin only routes
router.post('/register', auth, adminOnly, registerUser);
router.get('/', auth, adminOnly, getAllUsers);
router.put('/:userId', auth, adminOnly, updateUser);
router.delete('/:userId', auth, adminOnly, deleteUser);

module.exports = router;