const express = require('express');
const router = express.Router();
const { auth, adminOnly } = require('../middleware/auth');
const {
  getSystemStats,
  clearCache,
  getRateLimitStats
} = require('../controllers/systemController');

// All system routes require admin access
router.use(auth, adminOnly);

// System statistics
router.get('/stats', getSystemStats);

// Cache management
router.post('/cache/clear', clearCache);

// Rate limiting statistics
router.get('/rate-limits', getRateLimitStats);

module.exports = router;