const express = require('express');
const router = express.Router();
const { auth, staffOrAdmin } = require('../middleware/auth');
const upload = require('../middleware/upload');
const {
  getAllResearch,
  getResearchById,
  createResearch,
  updateResearch,
  deleteResearch,
  publishResearch
} = require('../controllers/researchController');

// Public routes
router.get('/', getAllResearch);
router.get('/:id', getResearchById);

// Protected routes (staff/admin only)
router.post('/', auth, staffOrAdmin, upload.single('thumb_image'), createResearch);
router.put('/:id', auth, staffOrAdmin, upload.single('thumb_image'), updateResearch);
router.delete('/:id', auth, staffOrAdmin, deleteResearch);
router.post('/:id/publish', auth, staffOrAdmin, publishResearch);

module.exports = router;
