const express = require('express');
const router = express.Router();
const publicationController = require('../controllers/publicationController');
const { auth, adminOnly } = require('../middleware/auth');

// Public routes
router.get('/', publicationController.getAllPublications);
router.get('/by-year', publicationController.getPublicationsByYear);
router.get('/stats', publicationController.getPublicationStats);
router.get('/:id', publicationController.getPublicationById);

// Admin routes
router.post('/', auth, adminOnly, publicationController.createPublication);
router.put('/:id', auth, adminOnly, publicationController.updatePublication);
router.delete('/:id', auth, adminOnly, publicationController.deletePublication);

module.exports = router;
