const express = require('express');
const router = express.Router();
const { auth, staffOrAdmin } = require('../middleware/auth');
const upload = require('../middleware/upload');
const {
  getAllNews,
  getNewsById,
  createNews,
  updateNews,
  deleteNews,
  publishNews
} = require('../controllers/newsController');

// Public routes
router.get('/', getAllNews);
router.get('/:id', getNewsById);

// Protected routes (staff/admin only)
router.post('/', auth, staffOrAdmin, upload.single('thumb_image'), createNews);
router.put('/:id', auth, staffOrAdmin, upload.single('thumb_image'), updateNews);
router.delete('/:id', auth, staffOrAdmin, deleteNews);
router.post('/:id/publish', auth, staffOrAdmin, publishNews);

module.exports = router;
