const express = require('express');
const router = express.Router();
const { auth, staffOrAdmin } = require('../middleware/auth');
const upload = require('../middleware/upload');
const {
  getAllMembers,
  getMemberTypes,
  getMemberById,
  createMember,
  updateMember,
  deleteMember
} = require('../controllers/memberController');

// Public routes
router.get('/', getAllMembers);
router.get('/types', getMemberTypes);
router.get('/:id', getMemberById);

// Protected routes (staff/admin only)
router.post('/', auth, staffOrAdmin, upload.single('image'), createMember);
router.put('/:id', auth, staffOrAdmin, upload.single('image'), updateMember);
router.delete('/:id', auth, staffOrAdmin, deleteMember);

module.exports = router;
