const express = require('express');
const router = express.Router();
const { auth, adminOnly, staffOrAdmin } = require('../middleware/auth');
const {
  getAllDynamicData,
  getDynamicDataByKey,
  createDynamicData,
  updateDynamicData,
  deleteDynamicData
} = require('../controllers/dynamicDataController');

// Public routes
router.get('/', getAllDynamicData);
router.get('/key/:key', getDynamicDataByKey);

// Protected routes (staff/admin only)
router.post('/', auth, staffOrAdmin, createDynamicData);
router.put('/:id', auth, staffOrAdmin, updateDynamicData);
router.delete('/:id', auth, adminOnly, deleteDynamicData);

module.exports = router;
