const express = require('express');
const router = express.Router();
const contactController = require('../controllers/contactController');
const { auth, adminOnly } = require('../middleware/auth');

// Bulk operations (must be before /:id routes)
router.post('/bulk/mark-read', auth, adminOnly, contactController.bulkMarkAsRead);
router.post('/bulk/delete', auth, adminOnly, contactController.bulkDelete);

// Public route - submit contact form
router.post('/', contactController.createContact);

// Admin routes - manage contact messages
router.get('/', auth, adminOnly, contactController.getAllContacts);
router.get('/:id', auth, adminOnly, contactController.getContactById);
router.patch('/:id/read', auth, adminOnly, contactController.updateReadStatus);
router.patch('/:id/notes', auth, adminOnly, contactController.addNotes);
router.delete('/:id', auth, adminOnly, contactController.deleteContact);

module.exports = router;
