const mongoose = require('mongoose');

const researchSchema = new mongoose.Schema({
  title: {
    type: String,
    required: true,
    trim: true
  },
  short_desc: {
    type: String,
    default: '',
    maxlength: 500
  },
  thumb_image: {
    type: String,
    default: ''
  },
  content: {
    type: mongoose.Schema.Types.Mixed, // Supports both HTML string and BlockNote JSON
    required: true
  },
  tags: [{
    type: String,
    trim: true
  }],
  status: {
    type: String,
    enum: ['draft', 'published'],
    default: 'draft'
  },
  published_at: {
    type: Date,
    default: null
  },
  created_by: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  tagged_members: [{
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Member'
  }]
}, {
  timestamps: true
});

// Index for faster queries
researchSchema.index({ status: 1, published_at: -1 });
researchSchema.index({ tags: 1 });

// Method to publish research
researchSchema.methods.publish = function() {
  this.status = 'published';
  this.published_at = new Date();
  return this.save();
};

module.exports = mongoose.model('Research', researchSchema);
