const mongoose = require('mongoose');

const publicationSchema = new mongoose.Schema({
  title: {
    type: String,
    required: true,
    trim: true
  },
  authors: [{
    type: String,
    trim: true
  }],
  year: {
    type: Number,
    required: true
  },
  journal: {
    type: String,
    trim: true
  },
  conference: {
    type: String,
    trim: true
  },
  volume: String,
  issue: String,
  pages: String,
  doi: String,
  url: String,
  abstract: String,
  type: {
    type: String,
    enum: ['journal', 'conference', 'book', 'chapter', 'preprint', 'thesis', 'other'],
    default: 'journal'
  },
  tags: [{
    type: String,
    trim: true
  }],
  citations: {
    type: Number,
    default: 0
  },
  pdf_url: String,
  thumbnail: String,
  featured: {
    type: Boolean,
    default: false
  },
  isPublished: {
    type: Boolean,
    default: true
  },
  order: {
    type: Number,
    default: 0
  }
}, {
  timestamps: true
});

// Indexes for efficient queries
publicationSchema.index({ year: -1, order: 1 });
publicationSchema.index({ type: 1, year: -1 });
publicationSchema.index({ featured: 1, year: -1 });
publicationSchema.index({ tags: 1 });

module.exports = mongoose.model('Publication', publicationSchema);
