const mongoose = require('mongoose');

const newsSchema = new mongoose.Schema({
  type: {
    type: String,
    required: true,
    enum: ['event', 'announcement', 'achievement', 'publication', 'other'],
    default: 'announcement'
  },
  title: {
    type: String,
    required: true,
    trim: true
  },
  thumb_image: {
    type: String,
    default: ''
  },
  short_desc: {
    type: String,
    default: '',
    maxlength: 500
  },
  content: {
    type: mongoose.Schema.Types.Mixed, // Supports both HTML string and BlockNote JSON
    required: true
  },
  status: {
    type: String,
    enum: ['draft', 'published'],
    default: 'draft'
  },
  published_at: {
    type: Date,
    default: null
  },
  created_by: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  tagged_members: [{
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Member'
  }]
}, {
  timestamps: true
});

// Index for faster queries
newsSchema.index({ status: 1, published_at: -1 });
newsSchema.index({ type: 1, status: 1 });

// Method to publish news
newsSchema.methods.publish = function() {
  this.status = 'published';
  this.published_at = new Date();
  return this.save();
};

module.exports = mongoose.model('News', newsSchema);
