const mongoose = require('mongoose');

const memberSchema = new mongoose.Schema({
  name: {
    type: String,
    required: true,
    trim: true
  },
  designation: {
    type: String,
    required: true,
    trim: true
  },
  image: {
    type: String,
    default: ''
  },
  bio: {
    type: String,
    default: ''
  },
  phones: [{
    type: String,
    trim: true
  }],
  emails: [{
    type: String,
    lowercase: true,
    trim: true
  }],
  member_type: {
    type: String,
    required: true,
    enum: [
      'Principal Investigator',
      'Co-Principal Investigator',
      'Research Associate',
      'PhD Student',
      'Graduated'
    ],
    trim: true
  },
  order: {
    type: Number,
    default: 0
  },
  status: {
    type: String,
    enum: ['active', 'inactive'],
    default: 'active'
  },
  social_links: {
    linkedin: { type: String, default: '' },
    github: { type: String, default: '' },
    scholar: { type: String, default: '' },
    website: { type: String, default: '' }
  },
  research_interests: [{
    type: String,
    trim: true
  }],
  statistics: {
    publications: { type: Number, default: 0 },
    phd_students: { type: Number, default: 0 },
    funding: { type: String, default: '' }
  }
}, {
  timestamps: true
});

// Index for sorting and filtering
memberSchema.index({ member_type: 1, order: 1 });
memberSchema.index({ status: 1 });

module.exports = mongoose.model('Member', memberSchema);
