const mongoose = require('mongoose');

// Get system stats and health
const getSystemStats = async (req, res) => {
  try {
    const stats = {
      timestamp: new Date().toISOString(),
      server: {
        uptime: process.uptime(),
        memory: process.memoryUsage(),
        cpu: process.cpuUsage(),
        nodeVersion: process.version,
        platform: process.platform
      },
      database: {
        status: mongoose.connection.readyState === 1 ? 'Connected' : 'Disconnected',
        host: mongoose.connection.host,
        name: mongoose.connection.name,
        collections: mongoose.connection.collections ? Object.keys(mongoose.connection.collections).length : 0
      }
    };

    res.json({
      success: true,
      stats
    });

  } catch (error) {
    console.error('System stats error:', error);
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
};

// Clear cache (admin only) - Not needed for new project
const clearCache = async (req, res) => {
  try {
    res.json({
      success: true,
      message: 'Cache clear not applicable'
    });
  } catch (error) {
    console.error('Clear cache error:', error);
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
};

// Get rate limiting stats
const getRateLimitStats = async (req, res) => {
  try {
    const stats = {
      timestamp: new Date().toISOString(),
      note: 'Rate limiting active via express-rate-limit'
    };

    res.json({
      success: true,
      stats
    });

  } catch (error) {
    console.error('Rate limit stats error:', error);
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
};

module.exports = {
  getSystemStats,
  clearCache,
  getRateLimitStats
};